(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     96844,       1778]
NotebookOptionsPosition[     95196,       1742]
NotebookOutlinePosition[     95590,       1759]
CellTagsIndexPosition[     95547,       1756]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Theorem 6.4", "Title",
 CellChangeTimes->{{3.8503675053983097`*^9, 3.8503675314147863`*^9}, {
   3.8504678198707952`*^9, 3.850467821360508*^9}, {3.8505617951146326`*^9, 
   3.8505618344846473`*^9}, 3.850567922474933*^9, {3.8510740780618935`*^9, 
   3.851074084526588*^9}},ExpressionUUID->"b7774f19-52c2-4281-bf2c-\
5e8e73e6ffb3"],

Cell["\<\

This Notebook contains the proof of the Theorem 6.4 in the paper 
\"The Shape of Central Quadrilaterals\" by Stanley Rabinowitz and Ercole Suppa.
submitted to the International Journal of Computer Discovered Mathematics 
(http : // www.journal - 1. eu/) in January 2022.
 
This Notebook is Copyright \[Copyright] January 2022 by Ercole Suppa \
(ercolesuppa@gmail.co) and is published with open access. This Notebook is \
distributed under the terms of the Creative Commons Attribution License which \
permits any use, distribution, and reproduction in any medium, provided the \
original author and the source are credited.\
\>", "Text",
 Evaluatable->False,
 CellChangeTimes->{{3.823362867312365*^9, 3.823362892123764*^9}, {
   3.823362940554699*^9, 3.823363012293025*^9}, {3.823423241988761*^9, 
   3.8234232521964083`*^9}, {3.848655919648938*^9, 3.8486559295098267`*^9}, {
   3.850294942155574*^9, 3.8502949868845367`*^9}, {3.850318910197069*^9, 
   3.850318919556775*^9}, {3.850318983141321*^9, 3.850319001844956*^9}, {
   3.8504678253995905`*^9, 3.8504678619153557`*^9}, {3.8509122249008703`*^9, 
   3.8509122320912*^9}, {3.850915578124196*^9, 3.850915607526987*^9}, {
   3.851074100743638*^9, 3.851074126415737*^9}, 
   3.851255323424818*^9},ExpressionUUID->"20c3d5cc-6413-4ddb-8d80-\
eb9263a009d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Support functions extracted from package ",
 StyleBox["baricentricas",
  FontWeight->"Bold"],
 ", written by Francisco Javier Garcia Capitan "
}], "Subsection",
 CellChangeTimes->{
  3.818667972143658*^9, {3.818668111169589*^9, 3.8186681230042787`*^9}, {
   3.8186687874835854`*^9, 3.8186687997295856`*^9}, 3.81868471982917*^9, {
   3.851073996835287*^9, 
   3.8510740052785416`*^9}},ExpressionUUID->"6a593de7-717a-42fe-b5f2-\
5003d362b07d"],

Cell[TextData[{
 "The full package ",
 StyleBox["baricentricas.m",
  FontWeight->"Bold",
  FontColor->GrayLevel[0]],
 " can be downloaded from:      ",
 ButtonBox["http : // garciacapitan.blogspot.com/2021/01/coordenadas - \
baricentricas.html",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://garciacapitan.blogspot.com/2021/01/coordenadas-baricentricas.\
html"], None},
  ButtonNote->
   "http://garciacapitan.blogspot.com/2021/01/coordenadas-baricentricas.html"]
}], "Text",
 CellChangeTimes->{{3.8186975420149603`*^9, 3.8186975893308125`*^9}, {
  3.818697637261342*^9, 3.81869763726334*^9}, {3.8504774633248463`*^9, 
  3.8504774678008566`*^9}},ExpressionUUID->"4450db2e-d2a2-4687-bea5-\
17e59a5d24c0"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Conway", " ", "notations"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SA", "=", 
     FractionBox[
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"], "-", 
       SuperscriptBox["a", "2"]}], "2"]}], ";", " ", 
    RowBox[{"SB", "=", 
     FractionBox[
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "2"]}], ";", 
    RowBox[{"SC", "=", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], "2"]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "funciones", " ", "para", " ", "reemplazar", " ", "valores", " ", "en", 
     " ", "una", " ", "expresi\[OAcute]n"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sustituir", "[", 
      RowBox[{"expr_", ",", "variable_", ",", "valor_"}], "]"}], ":=", 
     RowBox[{"Factor", "[", 
      RowBox[{"expr", " ", "/.", " ", 
       RowBox[{"Thread", "[", 
        RowBox[{"variable", "\[Rule]", "valor"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sustituirxyz", "[", 
      RowBox[{"f_", ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]_", ",", "\[Beta]_", ",", "\[Gamma]_"}], "}"}]}], 
      "]"}], ":=", 
     RowBox[{"Sustituir", "[", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}]}], 
      "]"}]}], " ", ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"TernaCiclica", "[", "expr", "]"}], " ", "returns", " ", 
       RowBox[{"{", 
        RowBox[{"expr1", ",", "expr2", ",", "expr3"}], "}"}], " ", "where", 
       " ", "expr1"}], "=", "expr"}], ",", " ", 
     RowBox[{"expr2", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"PermutarTerna", "[", "expr1", "]"}], " ", "and", " ", 
        "expr3"}], "=", 
       RowBox[{"PermutarTerna", "[", "expr2", "]"}]}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ReglaDePermutacion", "=", 
     RowBox[{"ReglaDePermutacion", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "b"}], ",", 
        RowBox[{"b", "\[Rule]", "c"}], ",", 
        RowBox[{"c", "\[Rule]", "a"}], ",", 
        RowBox[{"\[Alpha]", "\[Rule]", "\[Beta]"}], ",", 
        RowBox[{"\[Beta]", "\[Rule]", "\[Gamma]"}], ",", 
        RowBox[{"\[Gamma]", "\[Rule]", "\[Alpha]"}], ",", 
        RowBox[{"u", "\[Rule]", "v"}], ",", 
        RowBox[{"v", "\[Rule]", "w"}], ",", 
        RowBox[{"w", "\[Rule]", "u"}], ",", 
        RowBox[{"p", "\[Rule]", "q"}], ",", 
        RowBox[{"q", "\[Rule]", "r"}], ",", 
        RowBox[{"r", "\[Rule]", "p"}], ",", 
        RowBox[{"x", "\[Rule]", "y"}], ",", 
        RowBox[{"y", "\[Rule]", "z"}], ",", 
        RowBox[{"z", "\[Rule]", "x"}], ",", 
        RowBox[{"A", "\[Rule]", "B"}], ",", 
        RowBox[{"B", "\[Rule]", "C"}], ",", 
        RowBox[{"C", "\[Rule]", "A"}], ",", 
        RowBox[{"SA", "\[Rule]", "SB"}], ",", 
        RowBox[{"SB", "\[Rule]", "SC"}], ",", 
        RowBox[{"SC", "\[Rule]", "SA"}], ",", 
        RowBox[{"sa", "\[Rule]", "sb"}], ",", 
        RowBox[{"sb", "\[Rule]", "sc"}], ",", 
        RowBox[{"sc", "\[Rule]", "sa"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Permutar", "[", "expr_", "]"}], ":=", " ", 
     RowBox[{"expr", " ", "/.", "ReglaDePermutacion"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TernaCiclica", "[", "expr_", "]"}], " ", ":=", 
     RowBox[{"{", 
      RowBox[{"expr", ",", " ", 
       RowBox[{"Permutar", "[", "expr", "]"}], ",", 
       RowBox[{"Permutar", "[", 
        RowBox[{"Permutar", "[", "expr", "]"}], "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Simplificar", "[", "lista", "]"}], " ", "devuelve", " ", 
     "lista", " ", "dividida", " ", "por", " ", "su", " ", "M\[AAcute]ximo", 
     " ", "Com\[UAcute]n", " ", "Divisor"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Simplificar", "[", "list_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"gcd", ",", "lista"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"lista", "=", 
         RowBox[{"Factor", "[", "list", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"lista", "===", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", "lista", ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"gcd", "=", 
            RowBox[{"Apply", "[", 
             RowBox[{"PolynomialGCD", ",", "lista"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"lista", "=", 
            RowBox[{"Simplify", "[", 
             RowBox[{"Divide", "[", 
              RowBox[{"lista", ",", "gcd"}], "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"UnsameQ", "[", 
              RowBox[{
               RowBox[{"Denominator", "[", "gcd", "]"}], ",", "1"}], "]"}], 
             ",", 
             RowBox[{"lista", "=", 
              RowBox[{"Simplificar", "[", 
               RowBox[{"lista", " ", 
                RowBox[{"Denominator", "[", "gcd", "]"}]}], "]"}]}]}], 
            "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", "lista"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    StyleBox[
     RowBox[{
     "ecuaci\[OAcute]n", " ", "de", " ", "una", " ", "recta", " ", "que", " ",
       "pasa", " ", "por", " ", "dos", " ", "puntos"}],
     FontWeight->"Bold"], 
    StyleBox[" ",
     FontWeight->"Bold"], 
    StyleBox["*)",
     FontWeight->"Bold"]}], 
   StyleBox[" ",
    FontWeight->"Bold"], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"P_", ",", "Q_"}], "]"}], " ", ":=", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"Cross", "[", 
       RowBox[{"P", ",", "Q"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"interseccion", " ", "de", " ", "dos", " ", "rectas"}], " ", 
    StyleBox["*)",
     FontWeight->"Bold"]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Punto", "[", 
      RowBox[{"r_", ",", "s_"}], "]"}], " ", ":=", " ", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"Cross", "[", 
       RowBox[{"r", ",", "s"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "punto", " ", "del", " ", "infinito", " ", "de", " ", "una", " ", "recta",
      " ", "perpendicular", " ", "a", " ", "una", " ", "recta", " ", "cuyo", 
     " ", "punto", " ", "del", " ", "infinito", " ", "es", " ", "ptJ"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PuntoInfinitoPerpendicular", "[", "ptJ_", "]"}], " ", ":=", 
     RowBox[{"PuntoInfinito", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"SA", ",", "SB", ",", "SC"}], "}"}], "ptJ"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "recta", " ", "perpendicular", " ", "a", " ", "otra", " ", "pasando", " ",
      "por", " ", "un", " ", "punto"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PuntoInfinito", "[", 
      RowBox[{"{", 
       RowBox[{"p_", ",", "q_", ",", "r_"}], "}"}], "]"}], " ", ":=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"q", "-", "r"}], ",", 
       RowBox[{"r", "-", "p"}], ",", 
       RowBox[{"p", "-", "q"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Perpendicular", "[", 
      RowBox[{"P_", ",", "r_"}], "]"}], " ", ":=", 
     RowBox[{"Recta", "[", 
      RowBox[{"P", ",", 
       RowBox[{"PuntoInfinitoPerpendicular", "[", 
        RowBox[{"PuntoInfinito", "[", "r", "]"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Perpendicular", "[", 
      RowBox[{"P_", ",", "Q_", ",", "R_"}], "]"}], ":=", 
     RowBox[{"Perpendicular", "[", 
      RowBox[{"P", ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculo", " ", "del", " ", "ortocentro", " ", "del", " ", 
     "tri\[AAcute]ngulo", " ", "ABC"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_"}], "}"}], "]"}], " ", ":=", 
     " ", 
     RowBox[{"Punto", "[", 
      RowBox[{
       RowBox[{"Perpendicular", "[", 
        RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "]"}], ",", 
       RowBox[{"Perpendicular", "[", 
        RowBox[{"ptB", ",", "ptC", ",", "ptA"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calcula", " ", "el", " ", "\[AAcute]rea", " ", "de", " ", "un", " ", 
     "tri\[AAcute]ngulo"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AreaTriangulo", "[", 
      RowBox[{"{", 
       RowBox[{"P_", ",", "Q_", ",", "R_"}], "}"}], "]"}], " ", ":=", 
     RowBox[{"Factor", "[", 
      FractionBox[
       RowBox[{"Det", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}], 
       RowBox[{
        RowBox[{"Tr", "[", "P", "]"}], " ", 
        RowBox[{"Tr", "[", "Q", "]"}], " ", 
        RowBox[{"Tr", "[", "R", "]"}]}]], "]"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.800454214718548*^9, {3.8004545125571337`*^9, 3.8004545522620106`*^9}, {
   3.800454823663825*^9, 3.800454825213709*^9}, {3.8004548799575424`*^9, 
   3.80045493167925*^9}, {3.8004550228844185`*^9, 3.800455032322181*^9}, {
   3.800541517591076*^9, 3.8005415202139187`*^9}, {3.800541576118224*^9, 
   3.800541619198428*^9}, {3.8504693260035877`*^9, 3.8504693298535004`*^9}, {
   3.8504696257245083`*^9, 3.8504696447375326`*^9}, 3.8504723551991606`*^9, {
   3.8504727621325464`*^9, 3.8504727803188562`*^9}, {3.8504732048513374`*^9, 
   3.850473208157042*^9}, {3.850473648565755*^9, 3.8504736498256607`*^9}, {
   3.8504737473294554`*^9, 3.8504737479386873`*^9}, {3.8504737937107334`*^9, 
   3.8504738174177914`*^9}, {3.850474295952814*^9, 3.850474313805753*^9}, {
   3.850474380664278*^9, 3.8504744843179398`*^9}, {3.850474806608692*^9, 
   3.8504748552973075`*^9}, {3.8504759197123456`*^9, 3.850475921255512*^9}, {
   3.8504759713605905`*^9, 3.850475989464807*^9}, {3.850476575550455*^9, 
   3.850476577836243*^9}, {3.8504766181083813`*^9, 3.8504766473269916`*^9}, 
   3.850476830915382*^9, {3.85047733749861*^9, 3.850477347183383*^9}, {
   3.8504775310644264`*^9, 3.8504775480417814`*^9}, {3.8504776562952366`*^9, 
   3.850477657888199*^9}, {3.850477691257831*^9, 3.8504777395182476`*^9}, {
   3.8504777946094065`*^9, 3.8504778318856945`*^9}, {3.8504778879052052`*^9, 
   3.850477979968292*^9}, 3.85047801764312*^9, {3.85047805752918*^9, 
   3.8504781433438506`*^9}, {3.8504783920073695`*^9, 3.8504783936911545`*^9}, 
   3.850478526788954*^9, {3.850478609511713*^9, 3.850478653416582*^9}, {
   3.8504786913025217`*^9, 3.850478693318307*^9}, {3.850478740794073*^9, 
   3.8504787409729986`*^9}, {3.850478771789158*^9, 3.8504787935997972`*^9}, {
   3.850484068631645*^9, 3.8504840770175076`*^9}, {3.850484550888462*^9, 
   3.8504846052672358`*^9}, {3.8504847102887387`*^9, 3.850484735950554*^9}, {
   3.8504847855035887`*^9, 3.8504847864403706`*^9}, {3.8504871476004524`*^9, 
   3.850487149953966*^9}, {3.8504872253185596`*^9, 3.8504872259167852`*^9}, {
   3.8504878691388655`*^9, 3.850487872991275*^9}, {3.8505176008539124`*^9, 
   3.8505176371017017`*^9}, {3.8505481409495125`*^9, 
   3.8505481804024105`*^9}, {3.850548222854543*^9, 3.8505482529883375`*^9}, {
   3.8505488322145867`*^9, 3.850548833050748*^9}, {3.8505488800200253`*^9, 
   3.8505488925908394`*^9}, {3.850548927000965*^9, 3.8505489320600038`*^9}, {
   3.850550143778785*^9, 3.850550165531348*^9}, 3.8505539915737514`*^9, {
   3.850561615613713*^9, 3.8505616204784827`*^9}, {3.8505678506297703`*^9, 
   3.8505678517386513`*^9}, {3.8509153872758327`*^9, 3.8509154066306*^9}, {
   3.8509154401987057`*^9, 3.8509154685206223`*^9}, {3.8509187532712116`*^9, 
   3.850918753847083*^9}, {3.8510713538908405`*^9, 3.851071381215927*^9}, {
   3.851071422041388*^9, 3.8510714347834625`*^9}, {3.851071554905077*^9, 
   3.851071561007519*^9}, {3.851073866583305*^9, 3.8510739063186097`*^9}, {
   3.8510739684633207`*^9, 3.851073970287321*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"48231d8f-23c2-49aa-a295-4ae44c99add6"]
}, Closed]],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsnQtYVNX6/zf8NfVprD+nY381S82DmsdLaWqonSDLSylYCaaBmTdMvOEt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    "], {{0, 674}, {1296, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->{871.599999999999, Automatic},
  ImageSizeRaw->{1296, 674},
  PlotRange->{{0, 1296}, {0, 674}}]], "Text",
 CellChangeTimes->{
  3.850381830135684*^9},ExpressionUUID->"df3f27a1-98bc-42df-9856-\
fa863f037039"],

Cell["Let ABCD be general (convex) quadrilateral. ", "Text",
 CellChangeTimes->{{3.8503782925912457`*^9, 3.850378349557683*^9}, {
  3.8503783869889865`*^9, 3.8503784095202913`*^9}, {3.8503818509938483`*^9, 
  3.8503818566550465`*^9}, {3.850382462000075*^9, 
  3.850382465144022*^9}},ExpressionUUID->"8c7c8661-9cd4-49cd-b83d-\
8afde70f473b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ptA", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptB", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptC", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptD", "=", 
   RowBox[{"{", 
    RowBox[{"l", ",", "m", ",", "n"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Ortocentro", "[", 
    RowBox[{"{", 
     RowBox[{"ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Ortocentro", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptC", ",", "ptD"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Ortocentro", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptD"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptI", "=", 
   RowBox[{"Ortocentro", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AreaFGHI", "=", 
  RowBox[{
   RowBox[{"AreaTriangulo", "[", 
    RowBox[{"{", 
     RowBox[{"ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], "+", 
   RowBox[{"AreaTriangulo", "[", 
    RowBox[{"{", 
     RowBox[{"ptH", ",", "ptI", ",", "ptF"}], "}"}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.8503782853153486`*^9, 3.850378289863289*^9}, {
   3.8503783225842896`*^9, 3.8503783252889385`*^9}, {3.850378413612289*^9, 
   3.8503784234812546`*^9}, {3.8503785632216415`*^9, 3.850378564035082*^9}, {
   3.8503818595445757`*^9, 3.850381968191248*^9}, {3.8503822507111235`*^9, 
   3.850382258834524*^9}, 3.850382376180869*^9, {3.8510715063061852`*^9, 
   3.8510715074571037`*^9}, {3.8510740264495363`*^9, 3.851074027031285*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"1a08b1b3-ec16-4971-a3fb-bc4a23054fb9"],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox["m", 
   RowBox[{"l", "+", "m", "+", "n"}]]}]], "Output",
 CellChangeTimes->{{3.850381955631443*^9, 3.8503819690006785`*^9}, {
   3.850382261006606*^9, 3.8503822984960413`*^9}, 3.8503823365854087`*^9, {
   3.8503823776805024`*^9, 3.8503823820967627`*^9}, 3.850382470869183*^9, 
   3.8510713351293263`*^9, 3.85107151719511*^9, 3.8510739784572506`*^9, 
   3.8510740460928006`*^9, 3.851255336834399*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"fc5b7ed3-bb5b-4639-9a31-1fbecd796ac5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AreaABCD", "=", 
  RowBox[{
   RowBox[{"AreaTriangulo", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}], "]"}], "+", 
   RowBox[{"AreaTriangulo", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptC", ",", "ptD"}], "}"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.850382398580062*^9, 3.8503824351266003`*^9}, {
  3.851074033728631*^9, 3.851074035046754*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"b25e2a36-3006-4138-9205-f69081b3106f"],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox["m", 
   RowBox[{"l", "+", "m", "+", "n"}]]}]], "Output",
 CellChangeTimes->{3.8503824364888554`*^9, 3.850382472363813*^9, 
  3.851071521122651*^9, 3.8510739799948406`*^9, 3.851074047531094*^9, 
  3.8512553368422413`*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"0deb1d1e-cdfa-4a65-91c7-33750d506213"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"AreaFGHI", "-", "AreaABCD"}], "]"}]], "Input",
 CellChangeTimes->{{3.8503824775673685`*^9, 3.8503824878605275`*^9}, {
  3.851074038380434*^9, 3.851074042327739*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"c470b09b-2850-4b86-8654-bc20cfdfa14e"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.8503824885479574`*^9, 3.85107152227896*^9, 
  3.851073981493826*^9, 3.851074048894183*^9, 3.8512553368999243`*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"6c6c85c9-78e2-491e-b2fc-1660ae4e4462"]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{991, 1077},
WindowMargins->{{155, Automatic}, {Automatic, 67}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 335, 5, 98, "Title",ExpressionUUID->"b7774f19-52c2-4281-bf2c-5e8e73e6ffb3"],
Cell[918, 29, 1316, 23, 219, "Text",ExpressionUUID->"20c3d5cc-6413-4ddb-8d80-eb9263a009d1",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[2271, 57, 459, 11, 54, "Subsection",ExpressionUUID->"6a593de7-717a-42fe-b5f2-5003d362b07d"],
Cell[2733, 70, 715, 18, 58, "Text",ExpressionUUID->"4450db2e-d2a2-4687-bea5-17e59a5d24c0"],
Cell[3451, 90, 13280, 312, 1020, "Input",ExpressionUUID->"48231d8f-23c2-49aa-a295-4ae44c99add6"]
}, Closed]],
Cell[16746, 405, 74060, 1220, 464, "Text",ExpressionUUID->"df3f27a1-98bc-42df-9856-fa863f037039"],
Cell[90809, 1627, 340, 5, 35, "Text",ExpressionUUID->"8c7c8661-9cd4-49cd-b83d-8afde70f473b"],
Cell[CellGroupData[{
Cell[91174, 1636, 2054, 55, 199, "Input",ExpressionUUID->"1a08b1b3-ec16-4971-a3fb-bc4a23054fb9"],
Cell[93231, 1693, 527, 9, 49, "Output",ExpressionUUID->"fc5b7ed3-bb5b-4639-9a31-1fbecd796ac5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93795, 1707, 491, 11, 30, "Input",ExpressionUUID->"b25e2a36-3006-4138-9205-f69081b3106f"],
Cell[94289, 1720, 348, 7, 49, "Output",ExpressionUUID->"0deb1d1e-cdfa-4a65-91c7-33750d506213"]
}, Open  ]],
Cell[94652, 1730, 294, 5, 30, "Input",ExpressionUUID->"c470b09b-2850-4b86-8654-bc20cfdfa14e"],
Cell[94949, 1737, 243, 3, 34, "Output",ExpressionUUID->"6c6c85c9-78e2-491e-b2fc-1660ae4e4462"]
}
]
*)

